#ifndef SST_EXT_ATP_ITERATORS_H
#define SST_EXT_ATP_ITERATORS_H


#include "SST_Ext_DEFINES.h"
#include "sst_types.h"
/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */


#ifdef __cplusplus
extern "C"
{
#endif


  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 17 12:06:34 2009
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_Ext_ATP_Iterators.h#1:incl:1
   *  \author taniam
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************************ Structs  ******************************/

/*Data operations test struct*/
typedef struct EXT_ATP_IteratorTestDataStruct{  
    char              TST_Name[TST_NAME_STRING_LEN];
    DxByte_t                    TST_Password[TST_PASSWORD_STRING_LEN];
    DxUint32_t                  TST_PasswordSizeInBytes;
    DxUint32_t                  TST_MaxNumOfTrials;
    DxUint8_t                   TST_Data[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
    DxUint32_t                  TST_DataSize;
} EXT_ATP_IteratorTestDataStruct;

/*****************************************************************************
 * Function Name:                                                           
 *  SST_Ext_ATP_Iterator        
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  DxError_t - Function error return                                        
 *
 * Description:                                                                 
 *   Test the iteration services  begin, increment and get, decrement and get, 
 *       get all handles and terminate operations.
 *
 * Algorithm:       
 *    1.    Call to HOSTQA_ATP_Message function
 *
 *******************************************************************************/
  DxError_t SST_Ext_ATP_Iterator( void );
  
  
  
#ifdef __cplusplus
}
#endif

#endif
